<?php

$NETCAT_FOLDER = join( strstr(__FILE__, "/") ? "/" : "\\", array_slice( preg_split("/[\/\\\]+/", __FILE__), 0, -4 ) ).( strstr(__FILE__, "/") ? "/" : "\\" );
require_once ($NETCAT_FOLDER."vars.inc.php");
require_once "admin.inc.php";
require_once ($INCLUDE_FOLDER."s_common.inc.php");
require_once ($INCLUDE_FOLDER."s_loadenv.inc.php");
require_once ($ADMIN_FOLDER."function.inc.php");
require_once ($ROOT_FOLDER."connect_io.php");
require_once ($ADMIN_FOLDER."modules/ui.php");
require_once ($MODULE_FOLDER."nclog/ncLogAbstract.inc.php");
require_once ($MODULE_FOLDER."nclog/ncLogFile.inc.php");
require_once ($MODULE_FOLDER."nclog/ncLogDb.inc.php");
require_once ($MODULE_FOLDER."nclog/ncLog.inc.php");
require_once("ui_config.php");

global $ncLog, $UI_CONFIG;

$ncLog = new ncLog();
// language constants
if ( is_file($MODULE_FOLDER.'nclog/'.MAIN_LANG.'.lang.php') ) {
	require_once($MODULE_FOLDER.'nclog/'.MAIN_LANG.'.lang.php');
}
else {
	require_once($MODULE_FOLDER.'nclog/en.lang.php');
}

LoadModuleEnv();

// load modules env
if ( !isset($MODULE_VARS) ) $MODULE_VARS = $nc_core->modules->get_module_vars();

$Title1 = NETCAT_MODULES;
$Title2 = '   ';

BeginHtml ($Title2, $Title1, "http://".$DOC_DOMAIN."/settings/modules/nclog/");
echo "
	<script type='text/javascript' src='".$SUB_FOLDER."/netcat/modules/nclog/jquery.min.js'></script>
	<script type='text/javascript' src='".$SUB_FOLDER."/netcat/modules/nclog/admin.js'></script>
	<link href='".$SUB_FOLDER."/netcat/modules/nclog/admin.css' rel='stylesheet' type='text/css' />
";

$phase = isset($_REQUEST['phase']) ? intval($_REQUEST['phase']) : 1;
$perm->ExitIfNotAccess(NC_PERM_MODULE, 0, 0, 0, 0);

switch($phase) {
	/*
	 * Help
	 */
	case 3:
		if ( is_file($MODULE_FOLDER.'nclog/'.MAIN_LANG.'.lang.help.php') ) {
			require_once($MODULE_FOLDER.'nclog/'.MAIN_LANG.'.lang.help.php');
		}
		else {
			require_once($MODULE_FOLDER.'nclog/en.lang.help.php');
		}
		break;

	/*
	 * Error log
	 */
	case 2:
		$UI_CONFIG = new ui_config_module_nclog('admin', 'error');
		$fileList = $ncLog->errorGetLogs();
		$currentFile = isset($_REQUEST['file']) ? $_REQUEST['file'] : $fileList[count($fileList)-1];
		if(array_search($currentFile, $fileList) === FALSE) {
			$currentFile = $fileList[0];
		}

		$action = isset($_REQUEST['action']) ? $_REQUEST['action'] : null;
		if($action) {
			switch($action) {
				case "deleteForm":
					$ncLog->errorDelete($currentFile);
					break;

				case "deleteAllForm":
					foreach($fileList as $f) {
						$ncLog->errorDelete($f);
					}
					break;
			}

			unset($action);
			$fileList = $ncLog->errorGetLogs();
			$currentFile = $fileList[0];
		}

		if(empty($fileList)) {
			echo NETCAT_MODULE_NCLOG_ADMIN_ERROR_NONE;
			break;
		}

		$UI_CONFIG->actionButtons[] = array(
			"id" => "submit",
			"caption" => NETCAT_MODULE_NCLOG_ADMIN_ERROR_DELETE,
			"action" => "mainView.submitIframeForm('deleteForm')",
			"align" => "right"
		);

		$UI_CONFIG->actionButtons[] = array(
			"id" => "submit",
			"caption" => NETCAT_MODULE_NCLOG_ADMIN_ERROR_DELETEALL,
			"action" => "mainView.submitIframeForm('deleteAllForm')",
			"align" => "left"
		);

		echo "
			<div class='log-content-wrap'>
				<form method='post' action='admin.php' id='deleteForm' style='display: none;'>
					<input type='hidden' name='phase' value='2'/>
					<input type='hidden' name='file' value='".htmlspecialchars($currentFile, ENT_QUOTES)."'/>
					<input type='hidden' name='action' value='deleteForm'/>
				</form>
				<form method='post' action='admin.php' id='deleteAllForm' style='display: none;'>
					<input type='hidden' name='phase' value='2'/>
					<input type='hidden' name='file' value='".htmlspecialchars($currentFile, ENT_QUOTES)."'/>
					<input type='hidden' name='action' value='deleteAllForm'/>
				</form>
				<form method='post' action='admin.php' id='logForm'>
					<input type='hidden' name='phase' value='2'/>
	      			<fieldset>
						<legend>
							<b><font color='gray'>".NETCAT_MODULE_NCLOG_ADMIN_ERROR_LIST."</font></b>
	     				</legend>
						<div style='margin:10px 0; padding:0;'>
							<select name='file' onchange='this.form.submit();' style='width:50%'>";
								foreach($fileList as $row) {
									echo "
										<option value='".$row."' ".($currentFile == $row ? "selected='selected'" : NULL).">".str_replace("\\", "/", $row)."</option>
									";
								}
								echo "
							</select>
						</div>
					</fieldset>
				</form>
				<h3> ".htmlspecialchars(str_replace("\\", "/", $currentFile), ENT_QUOTES)."</h3>
			</div>
			<div class='events-log'>
					<table class='table-log'>
						<tr><th>".NETCAT_MODULE_NCLOG_ADMIN_ERROR_TH."</th></tr>
						";
						$content = $ncLog->errorGet($currentFile);
						foreach($content as $row) {
							echo "<tr><td>".strip_tags($row)."</td></tr>";
						}
						echo "
					</table>
			</div>
		";
		break;

	/*
	 * Events log
	 */
	case 1:
	default:
		$UI_CONFIG = new ui_config_module_nclog('admin', 'list');

		$eventsGroup = $ncLog->getEvents();

		$currentGroup = isset($_REQUEST['event_group']) && isset($eventsGroup[$_REQUEST['event_group']]) ? $_REQUEST['event_group'] : key($eventsGroup);
		$currentEvent = isset($_REQUEST['event']) && isset($eventsGroup[$currentGroup]) && array_search($_REQUEST['event'], $eventsGroup[$currentGroup]) !== false ? $_REQUEST['event'] : "";

		$options = array(
			'orderBy'	=> isset($_REQUEST['orderBy']) ? $_REQUEST['orderBy'] : null,
			'orderAsc'	=> isset($_REQUEST['orderAsc']) ? intval($_REQUEST['orderAsc']) : false,

			'startNum'	=> isset($_REQUEST['startNum']) ? intval($_REQUEST['startNum']) : 0,
			'limitNum'	=> $MODULE_VARS['nclog']['RESULTS_ON_PAGE']
		);

		if(isset($_REQUEST['action']))
			switch($_REQUEST['action']) {
				case "delete":
					$ncLog->delete($currentGroup, $currentEvent, $options);
					break;
			}

		$UI_CONFIG->actionButtons[] = array(
			"id" => "submit",
			"caption" => NETCAT_MODULE_NCLOG_ADMIN_LOG_DELETE,
			"action" => "mainView.oIframe.contentWindow.LogEventsFormDelete()",
			"align" => "right"
		);

		echo "
			<div class='log-content-wrap'>
				<form method='post' action='".$SUB_FOLDER."/netcat/modules/nclog/admin.php' id='logEventsForm'>
					<input type='hidden' name='phase' value='1'/>
					<input type='hidden' name='action' value=''/>
					<input type='hidden' name='orderBy' value='".$options['orderBy']."'/>
					<input type='hidden' name='orderAsc' value='".$options['orderAsc']."'/>
	      			<fieldset>
						<legend>
							<b><font color='gray'>".NETCAT_MODULE_NCLOG_ADMIN_LOG_LIST."</font></b>
	     				</legend>
						<div style='margin:10px 0; padding:0;'>
							<select name='event_group' class='select-event-group'>";
								foreach($eventsGroup as $key => $row) {
									echo "
										<option value='".htmlspecialchars($key, ENT_QUOTES)."' ".($currentGroup == $key ? "selected='selected'" : NULL).">".htmlspecialchars($key, ENT_QUOTES)."</option>
									";
								}
								echo "
							</select>";

							foreach($eventsGroup as $key => $row) {
								echo "<select name='event' event_group='".htmlspecialchars($key, ENT_QUOTES)."' onchange='this.form.submit();' class='select-event'>
									<option>".NETCAT_MODULE_NCLOG_ADMIN_LOG_CHOOSE."</option>
									<option value='' ".($currentGroup == $key && $currentEvent == ""? "selected='selected'" : NULL).">".NETCAT_MODULE_NCLOG_ADMIN_LOG_ALL."</option>";
								foreach($row as $item) {
									echo "
										<option value='".htmlspecialchars($item, ENT_QUOTES)."' ".($currentGroup == $key && $currentEvent == $item ? "selected='selected'" : NULL).">".htmlspecialchars($item, ENT_QUOTES)."</option>
									";
								}
								echo "</select>";
							}

							echo "
						</div>
					</fieldset>
				</form>
			</div>
		";

		$events = $ncLog->get($currentGroup, $currentEvent, $options);
		$eventsCount = $ncLog->getGetCount();
		$pages = ceil($eventsCount / $options['limitNum']);
		$pages = !$pages ? 1 : $pages;
		echo "
			<div class='events-log'>
					<table class='table-log'>
						<tr>
							<th width='2%' order_by='Priority' order_asc='".intval(!$options['orderAsc'])."'>".( $options['orderBy'] == "Priority" ? ( $options['orderAsc'] ? "&#8593;" : "&#8595;" )."&nbsp;" : NULL )."#</th>
							".(!$currentEvent ? "<th width='15%' order_by='Event' order_asc='".intval(!$options['orderAsc'])."'>".( $options['orderBy'] == "Event" ? ( $options['orderAsc'] ? "&#8593;" : "&#8595;" )."&nbsp;" : NULL ).NETCAT_MODULE_NCLOG_ADMIN_LOG_TH_EVENT."</th>" : NULL)."
							<th  width='15%' order_by='Date' order_asc='".intval(!$options['orderAsc'])."'>".( $options['orderBy'] == "Date" ? ( $options['orderAsc'] ? "&#8593;" : "&#8595;" )."&nbsp;" : NULL ).NETCAT_MODULE_NCLOG_ADMIN_LOG_TH_DATE."</th>
							<th width='3%' order_by='User_ID' order_asc='".intval(!$options['orderAsc'])."'>".( $options['orderBy'] == "User_ID" ? ( $options['orderAsc'] ? "&#8593;" : "&#8595;" )."&nbsp;" : NULL ).NETCAT_MODULE_NCLOG_ADMIN_LOG_TH_USER."</th>
							<th>".NETCAT_MODULE_NCLOG_ADMIN_LOG_TH_MESSAGE."</th>
						</tr>
						";
						$template = $DOCUMENT_ROOT.$SUB_FOLDER."/netcat/modules/nclog/admin_log_show.inc.php";
						if(file_exists($DOCUMENT_ROOT.$SUB_FOLDER."/netcat/modules/nclog/admin_log_show_user.inc.php")) {
							$template = $DOCUMENT_ROOT.$SUB_FOLDER."/netcat/modules/nclog/admin_log_show_user.inc.php";
						}
						foreach($events as $row) {
							include $template;
						}
						echo "
					</table>
			</div>
			<div class='log-content-wrap events-page-wrap'>
				<div class='events-page'>
					".($options['startNum'] ? "<a href='&startNum=".intval($options['startNum'] - $options['limitNum'] > 0 ? $options['startNum'] - $options['limitNum'] : 0)."' class='pages'>&larr;</a>" : "<span class='pages'>&larr;</span>")."
					<form id='logEventsPage' limit_num='".$options['limitNum']."'>
						<input type='text' name='pageNum' value='".intval(1 + $options['startNum'] / $options['limitNum'])."' /> ".NETCAT_MODULE_NCLOG_ADMIN_LOG_PAGE_OF." ".$pages."
					</form>
					".($options['startNum'] + $options['limitNum'] < $eventsCount ? "<a href='&startNum=".intval($options['startNum'] + $options['limitNum'])."' class='pages'>&rarr;</a>" : "<span class='pages'>&rarr;</span>")."
				</div>
			</div>
		";

		break;
}

EndHtml();
exit;
?>