<?php

/**
 * @author nex2hex nex2hex@ya.ru
 * @version 1.00
 */

include "ncLogAbstract.inc.php";
include "ncLogFile.inc.php";
include "ncLogDb.inc.php";
include "ncLog.inc.php";

global $ncLog, $DOCUMENT_ROOT, $SUB_FOLDER;

$MODULE_VARS = $nc_core->modules->get_module_vars();

$ncLog = new ncLog();

if(file_exists($DOCUMENT_ROOT.$SUB_FOLDER."/netcat/modules/nclog/ncLogSystem.inc.php")) {
	include $DOCUMENT_ROOT.$SUB_FOLDER."/netcat/modules/nclog/ncLogSystem.inc.php";

	if($MODULE_VARS['nclog']['SYSTEM_LOG']) {
		$ncLogSystem = new ncLogSystem();
	}
}

function nc_error_handler($code, $error, $file = NULL, $line = NULL) {
	if (error_reporting() & $code) {
		global $ncLog, $perm;

		if(is_object($ncLog)) {
			$error1 = $error;
			$error1 .= $file ? " ~ ".$file : "";
			$error1 .= $line ? " [".$line."]" : "";
			$error1 .= " REQUEST_URI: ".strip_tags( ( $_SERVER['HTTPS'] ? "https://" : "http://" ) . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] );
			$error1 .= " REQUEST_METHOD: ".strip_tags($_SERVER['REQUEST_METHOD']);

			$code1 = $code;
			if(is_int($code)) {
				$errorType = array (
					E_ERROR				=> 'ERROR',
					E_WARNING			=> 'WARNING',
					E_PARSE				=> 'PARSING ERROR',
					E_NOTICE			=> 'NOTICE',
					E_CORE_ERROR		=> 'CORE ERROR',
					E_CORE_WARNING		=> 'CORE WARNING',
					E_COMPILE_ERROR		=> 'COMPILE ERROR',
					E_COMPILE_WARNING	=> 'COMPILE WARNING',
					E_USER_ERROR		=> 'USER ERROR',
					E_USER_WARNING		=> 'USER WARNING',
					E_USER_NOTICE		=> 'USER NOTICE',
					E_STRICT			=> 'STRICT NOTICE',
					E_RECOVERABLE_ERROR	=> 'RECOVERABLE ERROR',
					E_DEPRECATED		=> 'E_DEPRECATED',
					E_USER_DEPRECATED	=> 'E_USER_DEPRECATED',
					E_ALL				=> 'E_ALL'
				);
				if(isset($errorType[$code])) {
					$code1 = $errorType[$code];
				}
			}

			$ncLog->errorAdd($code1, $code, $error1, array(
				'code'	=> $code,
				'error'	=> $error,
				'file'	=> $file,
				'line'	=> $line
			));
			unset($error1, $code1);

			// try to get user permissions, if user administrator, show error
			if(is_object($perm) && $perm->isInsideAdmin()) {
				return false;
			}
			return true;
		}
	}
	return false;
}

function nc_exception_handler(Exception $e) {
	$text = sprintf(
				'[%s]: %s',
				get_class($e), strip_tags($e->getMessage())
	);

	return nc_error_handler($e->getCode() || E_ERROR, $text, $e->getFile(), $e->getLine());
}

if($MODULE_VARS['nclog']['ERROR_HANDLER']) {
	// set custom error handlers
	set_exception_handler('nc_exception_handler');
	set_error_handler('nc_error_handler');
}

if(file_exists($DOCUMENT_ROOT.$SUB_FOLDER."/netcat/modules/nclog/nclog_config.inc.php")) {
	include $DOCUMENT_ROOT.$SUB_FOLDER."/netcat/modules/nclog/nclog_config.inc.php";
}

?>