<?php

/**
 * Log system events
 *
 * @author nex2hex nex2hex@ya.ru
 * @version 1.02
 */

class ncLogSystem {
	protected $ncLogDb, $db, $nc_core;

	public function __construct() {
		// global logging object
		$this->ncLogDb = ncLogDb::getInstance();

		// system superior object
		$nc_core = nc_Core::get_object();
		$this->nc_core = $nc_core;

		if ( is_object($nc_core->db) )
			$this->db = $nc_core->db;

		if(method_exists($nc_core->event, "get_all_events")) {
			$system_events = $nc_core->event->get_all_events();

			foreach ($system_events as $event) {
				$nc_core->event->bind( $this, $event);
			}
		} else {
			// NetCat 3.5
			$nc_core->event->bind( $this );
		}
	}

	// this magic method called on event execution
	public function __call($method, $args = array()) {
		$text 		= "";
		$options 	= array(
			'options'	=> $args
		);

		//find method type
		preg_match("/^(add|update|drop|check|uncheck|authorize)(.+)$/is", $method, $matches);
		if(isset($matches[1]) && isset($matches[2])) {
			switch ($matches[1]) {
				case "add":
				case "authorize":
					$options['priority'] = 1;
					break;

				case "update":
				case "check":
				case "uncheck":
					$options['priority'] = 2;
					break;

				case "drop":
					$options['priority'] = 3;
					break;
			}

			$method_name = "event".$matches[2];
			if(method_exists($this, $method_name)) {
				$text = $this->$method_name($matches[1], $args);
				$this->ncLogDb->add("NetCat", $matches[2], $text, $options);
			}
		}
	}

	/*
	 * Sprintf function with array
	 */
	protected function _sprintf($string, $args = array()) {
		array_unshift($args, $string);
		return call_user_func_array("sprintf", $args);
	}

	/*
	 * implode function with first id or array
	 */
	protected function _implodeId($args) {
		return "#".(is_array ( $args ) ? implode ( ", #", $args ) : $args);
	}

	/*
	 * NetCat logging events
	 */
	public function eventCatalogue($action, $args) {
		list($Catalogue_ID) = $args;

		if ($action != "drop" && !is_array ( $Catalogue_ID )) {
			$result = $this->db->get_row ( "
				SELECT
		  			CONCAT('" . $this->nc_core->ADMIN_PATH . "catalogue/index.php?phase=2&type=2&CatalogueID=', `Catalogue_ID`),
		  			CONCAT(`Catalogue_ID`, '. ', `Catalogue_Name`)
				FROM `Catalogue`
				WHERE `Catalogue_ID` = '" . intval ( $Catalogue_ID ) . "'
			", ARRAY_N );
			if($action == "add")
				$text = $this->_sprintf(NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_CATALOGUE_ADD, $result);
			else {
				$str = constant("NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_".strtoupper($action)) . NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_CATALOGUE_EDIT;
				$text = $this->_sprintf($str, $result);
			}
		} else {
			$text = NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_CATALOGUE_DROP.$this->_implodeId( $Catalogue_ID );
		}

		return $text;
	}

	public function eventSubdivision($action, $args) {
		list($Catalogue_ID, $Subdivision_ID) = $args;

		if ( $action!="drop" && !is_array($Subdivision_ID) ) {
			$result = $this->db->get_row ( "
				SELECT
					CONCAT('" . $this->nc_core->ADMIN_PATH . "subdivision/index.php?phase=5&SubdivisionID=', s.`Subdivision_ID`),
		  			CONCAT(s.`Subdivision_ID`, '. ', s.`Subdivision_Name`),
		  			CONCAT('" . $this->nc_core->ADMIN_PATH . "catalogue/index.php?phase=2&type=2&CatalogueID=', c.`Catalogue_ID`),
		 		 	CONCAT(c.`Catalogue_ID`, '. ', c.`Catalogue_Name`)
				FROM `Subdivision` AS s
				LEFT JOIN `Catalogue` AS c ON s.`Catalogue_ID` = c.`Catalogue_ID`
				WHERE s.`Subdivision_ID` = '" . intval ( $Subdivision_ID ) . "'
			", ARRAY_N );
			if($action == "add")
				$text = $this->_sprintf(NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_SUBDIVISION_ADD, $result);
			else {
				$str = constant("NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_".strtoupper($action)) . NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_SUBDIVISION_EDIT;
				$text = $this->_sprintf($str, $result);
			}
		} else {
			$result = $this->db->get_row ( "
				SELECT
		  			CONCAT('" . $this->nc_core->ADMIN_PATH . "catalogue/index.php?phase=2&type=2&CatalogueID=', `Catalogue_ID`),
		  			CONCAT(`Catalogue_ID`, '. ', `Catalogue_Name`)
				FROM `Catalogue`
				WHERE `Catalogue_ID` = '" . intval ( $Catalogue_ID ) . "'
			", ARRAY_N );
			$text = $this->_sprintf(NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_SUBDIVISION_DROP, $result);
			$text .= $this->_implodeId( $Subdivision_ID );
		}

		return $text;
	}

	public function eventSubClass($action, $args) {
		list($Catalogue_ID, $Subdivision_ID, $Sub_Class_ID) = $args;

		if ($action != "drop" && ! is_array ( $Sub_Class_ID )) {
			$result = $this->db->get_row ( "
				SELECT
					CONCAT('" . $this->nc_core->HTTP_ROOT_PATH . "?inside_admin=1&cc=', sc.`Sub_Class_ID`),
			  		CONCAT(sc.`Sub_Class_ID`, '. ', sc.`Sub_Class_Name`),
			  		CONCAT('" . $this->nc_core->ADMIN_PATH . "subdivision/index.php?phase=5&SubdivisionID=', s.`Subdivision_ID`),
			  		CONCAT(s.`Subdivision_ID`, '. ', s.`Subdivision_Name`),
			  		CONCAT('" . $this->nc_core->ADMIN_PATH . "catalogue/index.php?phase=2&type=2&CatalogueID=', c.`Catalogue_ID`),
			  		CONCAT(c.`Catalogue_ID`, '. ', c.`Catalogue_Name`)
				FROM `Sub_Class` AS sc
				LEFT JOIN `Subdivision` AS s ON sc.`Subdivision_ID` = s.`Subdivision_ID`
				LEFT JOIN `Catalogue` AS c ON s.`Catalogue_ID` = c.`Catalogue_ID`
				WHERE `Sub_Class_ID` = '" . intval ( $Sub_Class_ID ) . "'
			", ARRAY_N );
			if($action == "add")
				$text = $this->_sprintf(NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_SUBCLASS_ADD, $result);
			else {
				$str = constant("NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_".strtoupper($action)) . NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_SUBCLASS_EDIT;
				$text = $this->_sprintf($str, $result);
			}
		} else {
			$result = $this->db->get_row ( "
				SELECT
		  			CONCAT('" . $this->nc_core->ADMIN_PATH . "catalogue/index.php?phase=2&type=2&CatalogueID=', c.`Catalogue_ID`),
		  			CONCAT(c.`Catalogue_ID`, '. ', c.`Catalogue_Name`),
		  			CONCAT('" . $this->nc_core->ADMIN_PATH . "subdivision/index.php?phase=5&SubdivisionID=', `Subdivision_ID`),
		  			CONCAT(`Subdivision_ID`, '. ', `Subdivision_Name`)
				FROM `Subdivision` AS s
				LEFT JOIN `Catalogue` AS c ON s.`Catalogue_ID` = c.`Catalogue_ID`
				WHERE s.`Subdivision_ID` = '" . intval ( $Subdivision_ID ) . "'
			", ARRAY_N );
			$text = $this->_sprintf(NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_SUBCLASS_DROP, $result);
			$text .= $this->_implodeId( $Sub_Class_ID );
		}

		return $text;
	}

	public function eventClass($action, $args) {
		list($Class_ID) = $args;

		if ($action != "drop" && ! is_array ( $Class_ID )) {
			$result = $this->db->get_row ( "
				SELECT
		  			CONCAT('" . $this->nc_core->ADMIN_PATH . "class/index.php?phase=4&ClassID=', `Class_ID`),
		  			CONCAT(`Class_ID`, '. ', `Class_Name`)
				FROM `Class`
				WHERE `Class_ID` = '" . intval ( $Class_ID ) . "'
			", ARRAY_N );
			if($action == "add")
				$text = $this->_sprintf(NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_CLASS_ADD, $result);
			else {
				$str = constant("NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_".strtoupper($action)) . NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_CLASS_EDIT;
				$text = $this->_sprintf($str, $result);
			}
		} else {
			$text =  NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_CLASS_DROP.$this->_implodeId( $Class_ID );
		}

		return $text;
	}

	public function eventClassTemplate($action, $args) {
		list($Class_ID, $Class_Template_ID) = $args;

		if ($action != "drop" && ! is_array ( $Class_Template_ID )) {
			$result = $this->db->get_row ( "
				SELECT
					CONCAT('" . $this->nc_core->ADMIN_PATH . "class/index.php?phase=16&ClassID=', ct.`Class_ID`),
		  			CONCAT(ct.`Class_ID`, '. ', ct.`Class_Name`),
		  			CONCAT('" . $this->nc_core->ADMIN_PATH . "class/index.php?phase=4&ClassID=', c.`Class_ID`),
		 			CONCAT(c.`Class_ID`, '. ', c.`Class_Name`)
				FROM `Class` AS ct
				LEFT JOIN `Class` AS c ON ct.`ClassTemplate` = c.`Class_ID`
				WHERE ct.`Class_ID` = '" . intval ( $Class_Template_ID ) . "'
			", ARRAY_N );
			if($action == "add")
				$text = $this->_sprintf(NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_CLASSTEMPLATE_ADD, $result);
			else {
				$str = constant("NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_".strtoupper($action)) . NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_CLASSTEMPLATE_EDIT;
				$text = $this->_sprintf($str, $result);
			}
		} else {
			$result = $this->db->get_row ( "
				SELECT
		  			CONCAT('" . $this->nc_core->ADMIN_PATH . "class/index.php?phase=4&ClassID=', `Class_ID`),
		  			CONCAT(`Class_ID`, '. ', `Class_Name`)
				FROM `Class`
				WHERE `Class_ID` = '" . intval ( $Class_ID ) . "'
			", ARRAY_N );
			$text = $this->_sprintf(NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_CLASSTEMPLATE_DROP, $result);
			$text .= $this->_implodeId( $Class_Template_ID );
		}

		return $text;
	}

	public function eventMessage($action, $args) {
		list($Catalogue_ID, $Subdivision_ID, $Sub_Class_ID, $Class_ID, $Message_ID) = $args;

		$result = $this->db->get_row ( "
			SELECT
				CONCAT('" . $this->nc_core->ADMIN_PATH . "catalogue/index.php?phase=2&type=2&CatalogueID=', c.`Catalogue_ID`),
				CONCAT(c.`Catalogue_ID`, '. ', c.`Catalogue_Name`),
				CONCAT('" . $this->nc_core->ADMIN_PATH . "subdivision/index.php?phase=5&SubdivisionID=', s.`Subdivision_ID`),
				CONCAT(s.`Subdivision_ID`, '. ', s.`Subdivision_Name`),
				CONCAT('" . $this->nc_core->HTTP_ROOT_PATH . "?inside_admin=1&cc=', sc.`Sub_Class_ID`),
				CONCAT(sc.`Sub_Class_ID`, '. ', sc.`Sub_Class_Name`),
				CONCAT('" . $this->nc_core->ADMIN_PATH . "class/index.php?phase=4&ClassID=', cl.`Class_ID`),
				CONCAT(cl.`Class_ID`, '. ', cl.`Class_Name`)
	  		FROM `Sub_Class` AS sc
	  		LEFT JOIN `Subdivision` AS s ON sc.`Subdivision_ID` = s.`Subdivision_ID`
	  		LEFT JOIN `Catalogue` AS c ON s.`Catalogue_ID` = c.`Catalogue_ID`
	  		LEFT JOIN `Class` AS cl ON sc.`Class_ID` = cl.`Class_ID`
	  		WHERE `Sub_Class_ID` = '" . intval ( $Sub_Class_ID ) . "'
	  	", ARRAY_N );

		// no result
		if (! is_array ( $result ))
			return $action;

		// format
		if (is_array ( $Message_ID )) {
			$result [8] = $result [4];
			$result [9] = "#" . implode ( ", #", $Message_ID );
		} else {
			$result [8] = $action != "drop" ? $this->nc_core->HTTP_ROOT_PATH . "full.php?inside_admin=1&catalogue=" . $Catalogue_ID . "&sub=" . $Subdivision_ID . "&cc=" . $Sub_Class_ID . "&message=" . $Message_ID : $result [5];
			$result [9] = "#" . $Message_ID;
		}

		if($action == "add")
			$text = $this->_sprintf(NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_MESSAGE_ADD, $result);
		elseif($action == "drop")
			$text = $this->_sprintf(NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_MESSAGE_DROP, $result);
		else {
			$str = constant("NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_".strtoupper($action)) . NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_MESSAGE_EDIT;
			$text = $this->_sprintf($str, $result);
		}

		return $text;
	}

	public function eventSystemTable($action, $args) {
		list($System_Table_ID, $Essence_ID) = $args;

		if ($action != "drop" && ! is_array ( $System_Table_ID )) {
			$result = array ($this->nc_core->ADMIN_PATH . "field/index.php?isSys=1&SystemTableID=" . $System_Table_ID, "#" . $System_Table_ID );
			if($action == "add")
				$text = $this->_sprintf(NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_SYSTEMTABLE_ADD, $result);
			else {
				$str = constant("NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_".strtoupper($action)) . NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_SYSTEMTABLE_EDIT;
				$text = $this->_sprintf($str, $result);
			}
		} else {
			$text = NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_SYSTEMTABLE_DROP.$this->_implodeId( $System_Table_ID );
		}

		return $text;
	}

	public function eventTemplate($action, $args) {
		list($Template_ID) = $args;

		if ($action != "drop" && ! is_array ( $Template_ID )) {
			$result = $this->db->get_row ( "
				SELECT
					CONCAT('" . $this->nc_core->ADMIN_PATH . "template/index.php?phase=4&TemplateID=', `Template_ID`),
					CONCAT(`Template_ID`, '. ', `Description`)
	   			FROM `Template`
				WHERE `Template_ID` = '" . intval ( $Template_ID ) . "'
			", ARRAY_N );
			if($action == "add")
				$text = $this->_sprintf(NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_TEMPLATE_ADD, $result);
			else {
				$str = constant("NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_".strtoupper($action)) . NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_TEMPLATE_EDIT;
				$text = $this->_sprintf($str, $result);
			}
		} else {
			$text = NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_TEMPLATE_DROP.$this->_implodeId( $Template_ID );
		}

		return $text;
	}

	public function eventUser($action, $args) {
		global $AUTHORIZE_BY;

		list($User_ID) = $args;

		if ($action != "drop" && ! is_array ( $User_ID )) {
			$result = $this->db->get_row ( "
				SELECT
					CONCAT('" . $this->nc_core->ADMIN_PATH . "user/index.php?phase=4&UserID=', `User_ID`),
					`".$this->db->escape($AUTHORIZE_BY)."`
				FROM `User`
				WHERE `User_ID` = '" . intval ( $User_ID ) . "'
			", ARRAY_N );
			if($action == "add")
				$text = $this->_sprintf(NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_USER_ADD, $result);
			elseif($action == "authorize")
				$text = $this->_sprintf(NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_USER_AUTHORIZE, $result);
			else {
				$str = constant("NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_".strtoupper($action)) . NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_USER_EDIT;
				$text = $this->_sprintf($str, $result);
			}
		} else {
			$text = NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_USER_DROP.$this->_implodeId($User_ID);
		}

		return $text;
	}
	
	public function eventComment($action, $args) {
		global $AUTHORIZE_BY;

		list($Catalogue_ID, $Subdivision_ID, $Sub_Class_ID, $Class_ID, $Message_ID, $Comment_ID) = $args;

		$result = $this->db->get_row ( "
			SELECT
				CONCAT('".$this->nc_core->ADMIN_PATH."catalogue/index.php?phase=2&type=2&CatalogueID=', c.`Catalogue_ID`),
				CONCAT(c.`Catalogue_ID`, '. ', c.`Catalogue_Name`),
				CONCAT('".$this->nc_core->ADMIN_PATH."subdivision/index.php?phase=5&SubdivisionID=', s.`Subdivision_ID`),
				CONCAT(s.`Subdivision_ID`, '. ', s.`Subdivision_Name`),
				CONCAT('".$this->nc_core->HTTP_ROOT_PATH."?inside_admin=1&cc=', sc.`Sub_Class_ID`),
				CONCAT(sc.`Sub_Class_ID`, '. ', sc.`Sub_Class_Name`),
				CONCAT('".$this->nc_core->HTTP_ROOT_PATH."class/index.php?phase=4&ClassID=', cl.`Class_ID`),
				CONCAT(cl.`Class_ID`, '. ', cl.`Class_Name`)
			  FROM `Sub_Class` AS sc
			  LEFT JOIN `Subdivision` AS s ON sc.`Subdivision_ID` = s.`Subdivision_ID`
			  LEFT JOIN `Catalogue` AS c ON s.`Catalogue_ID` = c.`Catalogue_ID`
			  LEFT JOIN `Class` AS cl ON sc.`Class_ID` = cl.`Class_ID`
			  WHERE `Sub_Class_ID` = '".intval($Sub_Class_ID)."'
		", ARRAY_N );
		
		if ( !is_array($result) ) return false;

		// format
		$result[9] = $this->nc_core->HTTP_ROOT_PATH."full.php?inside_admin=1&catalogue=".$Catalogue_ID."&sub=".$Subdivision_ID."&cc=".$Sub_Class_ID."&message=".$Message_ID;
		$result[10] = "#".$Message_ID;
		
		$result[11] = nc_message_link($Message_ID, $Class_ID).( $action != 'drop' ? "#nc_commentID".$Sub_Class_ID."_".$Message_ID."_".$Comment_ID : "");
		$result[12] = "#".$Comment_ID;
		
		$str = constant("NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_".strtoupper($action)) . NETCAT_MODULE_NCLOG_ADMIN_LOG_SYSTEM_COMMENT;
		$text = $this->_sprintf($str, $result);

		return $text;
	}
}

?>