$(function() {
	var _height = 25;
	$(".log-content-wrap").each(function() {
		_height += $(this)[0].offsetHeight;
	});
	if($.browser.msie) {
		_height += 20;
	}
	var doOnResize = function() {
		$(".events-log").each(function(){
			$(this).removeAttr("style");
			var height = ($.browser.msie ? $("body").height() : window.innerHeight) - _height;
			if (height > 0) {
				$(this).css({
					height: height + "px"
				});
			}
		});
	}
	$(window).bind("resize", function(){
		setTimeout(function(){
			doOnResize();
		}, 500);
	})
	doOnResize();
	
	// logEventsForm actions
	InstallLogEventsForm();
});

function InstallLogEventsForm() {
	var $form = $("#logEventsForm");
	if (!$form.length) 		
		return;
	
	$selectList = $(".select-event", $form);
	$(".select-event-group", $form).bind("change", function() {
		$selectList.hide().attr("name", "");
		$selectList.filter("[event_group='" + $(this).attr("value") + "']").attr("name", "event").show();
	}).trigger("change");
	
	// order by
	$(".events-log table.table-log").find("th").bind("click", function() {
		var $this = $(this);
		if (!$this.attr("order_by")) 		
			return false;
		
		$("input[name='orderBy']", $form).attr("value", $this.attr("order_by"));	
		$("input[name='orderAsc']", $form).attr("value", $this.attr("order_asc"));

		location.href = $form.attr("action") + "?" + $form.serialize();
		
		return false;
	});
	
	// page listing
	$(".events-page").find("a.pages").bind("click", function() {
		location.href = $form.attr("action") + "?" + $form.serialize() + $(this).attr("href");
		return false;
	});
	
	$("#logEventsPage").bind("submit", function(){
		var $this = $(this);
		var startNum = ( parseInt( $("input[name='pageNum']", $this).attr("value") ) - 1 ) * parseInt($this.attr("limit_num"));
		if(isNaN(startNum) || startNum < 0) 
			return false;
			
		location.href = $form.attr("action") + "?" + $form.serialize() + "&startNum=" + startNum;
		
		return false;
	});
}

function LogEventsFormDelete() {
	var $form = $("#logEventsForm");
	if (!$form.length) 		
		return;
		
	$("input[name='action']", $form).attr("value", "delete");
	location.href = $form.attr("action") + "?" + $form.serialize();
	
	return false;
}