<?php

/**
 * @author nex2hex nex2hex@ya.ru
 * @version 1.01
 */

class ncLogDb extends ncLogAbsctract {
	protected $db;
	protected $getCount = 0;

	private static $instance;
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self;
            self::$instance->init();
        }
        return self::$instance;
    }

    protected function init() {
		// system superior object
		$nc_core = nc_Core::get_object ();
		// system db object
		if (is_object ( $nc_core->db ))
			$this->db = $nc_core->db;
    }

	public function add($eventGroup, $event, $message, $options = array()) {
		// if callback return false
		if(!parent::add($eventGroup, $event, $message, $options)) {
			return false;
		}

		$db = $this->db;
		return $db->query("
			INSERT INTO `ncLog`
			(`EventGroup`, `Event`, `Date`, `Priority`, `User_ID`, `Text`, `AdditionalText`)
			VALUES
			(	'".$db->escape($eventGroup)."',
				'".$db->escape($event)."',
				'".$db->escape($options['date'])."',
				".$options['priority'].",
				".$options['userId'].",
				'".$db->escape($message)."',
				'".$db->escape(serialize($options['options']))."'
			)
		");
	}

	public function delete($eventGroup, $event = "", $options = array()) {
		$eventGroup = $this->filterEvent($eventGroup);
		$event		= $this->filterEvent($event);
		$options 	= $this->filterOptions($options);

		$db = $this->db;
		return $db->query("
			DELETE
			FROM `ncLog`
			WHERE 1=1
				".($eventGroup ? "AND `EventGroup` = '".$db->escape($eventGroup)."'" : NULL)."
				".($event ? "AND `Event` = '".$db->escape($event)."'" : NULL)."
				".($options['startDate'] ? "AND `Date` => '".$options['startDate']."'" : NULL)."
				".($options['stopDate'] ? "AND `Date` <= '".$options['stopDate']."'" : NULL)."
				".($options['userId'] !== false ? "AND `User_ID` = ".$options['userId']."" : NULL)."
		");
	}

	public function get($eventGroup, $event = "", $options = array()) {
		$eventGroup = $this->filterEvent($eventGroup);
		$event		= $this->filterEvent($event);
		$options 	= $this->filterOptions($options);

		global $AUTHORIZE_BY;
		$db = $this->db;
		$query = "
			SELECT %SELECT
			FROM `ncLog` as a
			LEFT JOIN `User` as b ON a.`User_ID` = b.`User_ID`
			WHERE a.`EventGroup` = '".$db->escape($eventGroup)."'
				".($event ? "AND a.`Event` = '".$db->escape($event)."'" : NULL)."
				".($options['startDate'] ? "AND a.`Date` => '".$options['startDate']."'" : NULL)."
				".($options['stopDate'] ? "AND a.`Date` <= '".$options['stopDate']."'" : NULL)."
				".($options['userId'] !== false ? "AND a.`User_ID` = ".$options['userId']."" : NULL)."
			ORDER BY a.`".$options['orderBy']."` ".$options['orderAsc']."
		";

		$results = $db->get_results(
			str_replace("%SELECT", "a.*, b.`".$db->escape($AUTHORIZE_BY)."` as UserLogin", $query)
			."LIMIT ".($options['startNum'] ? $options['startNum'].", " : NULL)." ".$options['limitNum']
		, ARRAY_A);
		$results = is_array($results) ? $results : array();

		foreach($results as $key => &$val) {
			$val['options'] = unserialize($val['AdditionalText']);
			unset($val['AdditionalText']);
		}

		$this->getCount = $db->get_var(str_replace("%SELECT", "COUNT(*)", $query));
		return $results;
	}

	public function getGetCount() {
		return $this->getCount;
	}

	public function getEvents() {
		$db = $this->db;
		$db->query("SET SESSION group_concat_max_len = 10240");

		$res = $db->get_results("
			SELECT a.`EventGroup`, GROUP_CONCAT(DISTINCT a.`Event`) as EventString
			FROM `ncLog` as a
			GROUP BY a.`EventGroup`
		", ARRAY_A);

		$results = array();
		$res = is_array($res) ? $res : array();

		foreach($res as $key => $val) {
			$results[$val['EventGroup']] = explode(",", $val['EventString']);
		}
		unset($res);

		return $results;
	}

	/**
	 * @param array $options
	 *
	 * You can use:
	 *		startNum
	 *		limitNum
	 *		startDate	// use $timestamp format
	 *		stopDate
	 *		userId
	 *
	 *		orderBy // 'Date', 'Event', 'Priority', 'User_ID'
	 *		orderAsc // boolean
	 *
	 * @return array filtered options
	 */
	protected function filterOptions($options = array()) {
		$ordersBy = array('Date', 'Event', 'Priority', 'User_ID');

		$options += array(
			'startNum'		=> 0,
			'limitNum'		=> 100,
			'startDate'		=> '',
			'stopDate'		=> '',
			'userId'		=> false,
			'orderBy'		=> $ordersBy[0],
			'orderAsc'		=> false,
			'options'		=> array()
		);

		$options['startNum']	= intval($options['startNum']);
		$options['limitNum']	= intval($options['limitNum']);
		$options['userId']		= $options['userId'] === false ? false : intval($options['userId']);

		// check dates
		if($options['startDate']) {
			$options['startDate'] = date(self::$timestamp, strtotime($options['startDate']));
		}

		if($options['stopDate']) {
			$options['stopDate'] = date(self::$timestamp, strtotime($options['stopDate']));
		}

		// check order by
		if( array_search( $options['orderBy'], $ordersBy ) === false ) {
			$options['orderBy'] = $ordersBy[0];
		}
		$options['orderAsc'] = $options['orderAsc'] ? "ASC" : "DESC";

		return $options;
	}
}
