<?php

/**
 * @author nex2hex nex2hex@ya.ru
 * @version 1.00
 */

class ncLogFile extends ncLogAbsctract {

	public static $directory;
	protected static $currentFile;
	protected $logFiles;

	private static $instance;
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self;
            self::$instance->init();
        }
        return self::$instance;
    }

	protected function init() {
		global $DOCUMENT_ROOT, $HTTP_CACHE_PATH;
		self::$directory = $DOCUMENT_ROOT.$HTTP_CACHE_PATH."nclog";
		$dir = self::$directory.DIRECTORY_SEPARATOR.date('Y');

		if(!is_dir($dir)) {
			mkdir($dir, 0755, true);
			chmod($dir, 0755);
		}

		// current file to log events
		self::$currentFile = date('Y').DIRECTORY_SEPARATOR.date('m_d').".php";
		$this->logFiles = null;
	}

	/**
	 * Add event to file
	 *
	 *
	 * @param string $event
	 * @param string $message
	 * @param array $options (use $options['time'] and $options['userId'], other options ignored)
	 * @return number of writen bytes
	 */
	public function add($eventGroup, $event, $message, $options = array()) {
		// if callback return false
		if(!parent::add($eventGroup, $event, $message, $options)) {
			return false;
		}

		// create new log file
		$filename = self::$directory.DIRECTORY_SEPARATOR.self::$currentFile;
		if ( ! file_exists($filename)) {
			file_put_contents($filename, "<?php \$nc_core = nc_Core::get_object (); if (!is_object ( \$nc_core )) exit; ?>".PHP_EOL);
			chmod($filename, 0666);
		}

		$messageWrite = $options['date']." --- ".$eventGroup.": ".$event." --- user #".$options['userId'].": ".$message;
		return @file_put_contents($filename, PHP_EOL.$messageWrite, FILE_APPEND);
	}

	/**
	 * Get log files
	 *
	 * @return array
	 */
	public function getLogs() {
		if(empty($this->logFiles)) {
			$results = array();
			foreach (new DirectoryIterator(self::$directory) as $currentDir) {
				if(!$currentDir->isDir() || $currentDir->isDot()) {
		    		continue;
		    	}
		    	foreach ( new DirectoryIterator(self::$directory.DIRECTORY_SEPARATOR.$currentDir->getFilename()) as $file ) {
					if($file->isFile()) {
						$results[] = $currentDir.DIRECTORY_SEPARATOR.$file->getFilename();
					}
		    	}
			}
			$this->logFiles = $results;
		}

		return $this->logFiles;
	}

	/**
	 * Get events from file.
	 *
	 * @param string $file
	 * @return array
	 */
	public function get($file) {
		if(!$this->fileCheck($file)) {
			return array();
		}

		$results = file(self::$directory.DIRECTORY_SEPARATOR.$file);
		array_shift($results);
		array_shift($results);
		$results = array_reverse($results);
		return $results;
	}

	/**
	 * Delete files
	 *
	 * @param array $files
	 */
	public function delete($files) {
		if(!is_array($files)) {
			$files = array($files);
		}

		foreach ($files as $file) {
			if(!$this->fileCheck($file)) {
				continue;
			}
			@unlink(self::$directory.DIRECTORY_SEPARATOR.$file);
		}

		foreach (new DirectoryIterator(self::$directory) as $currentDir) {
			$i = 0;
			if(!$currentDir->isDir() || $currentDir->isDot()) {
		    	continue;
		    }
		    $dir = self::$directory.DIRECTORY_SEPARATOR.$currentDir->getFilename();
			foreach ( new DirectoryIterator($dir) as $file ) {
				if($file->isFile()) {
					$i++;
				}
		    }
		    if(!$i) {
		    	@unlink($dir);
		    }
		}

		$this->init();
	}

	protected function fileCheck($file) {
		return is_int(array_search($file, $this->getLogs()));
	}
}