<?php
use \CDNVideo\CDNChain;

class ncCDNVideo {
    
    public static function getCDNVideoCofig(){
        // получаем объект nc_core
        $nc_core = nc_Core::get_object();

        // загрузка дефолтных расширений
        $nc_core->load_default_extensions();        
        $MODULE_VARS = $nc_core->modules->get_module_vars();
        
        $config = array(
            'active' => isset($MODULE_VARS['CDNVideo']['CDN_Video_Active'])? $MODULE_VARS['CDNVideo']['CDN_Video_Active'] === 'true': false,
            'id' => isset($MODULE_VARS['CDNVideo']['CDN_Video_ID'])? (int)$MODULE_VARS['CDNVideo']['CDN_Video_ID'] : 0,
            'domain' => isset($MODULE_VARS['CDNVideo']['CDN_Video_URL']) && !empty($MODULE_VARS['CDNVideo']['CDN_Video_URL']) ? $MODULE_VARS['CDNVideo']['CDN_Video_URL'] : '',
            'init_time' => isset($MODULE_VARS['CDNVideo']['CDN_Video_Cache']) && !empty($MODULE_VARS['CDNVideo']['CDN_Video_Cache']) ? (int)$MODULE_VARS['CDNVideo']['CDN_Video_Cache'] : time(),
            'ttl' => isset($MODULE_VARS['CDNVideo']['CDN_Video_TTL']) && !empty($MODULE_VARS['CDNVideo']['CDN_Video_TTL']) ? (int)$MODULE_VARS['CDNVideo']['CDN_Video_TTL'] : 14*24*3600,
            'active_av' => isset($MODULE_VARS['CDNVideo']['CDN_Video_Active_AV'])? $MODULE_VARS['CDNVideo']['CDN_Video_Active_AV'] === 'true': false,
            'domain_av' => isset($MODULE_VARS['CDNVideo']['CDN_Video_URL_AV']) && !empty($MODULE_VARS['CDNVideo']['CDN_Video_URL_AV']) ? $MODULE_VARS['CDNVideo']['CDN_Video_URL_AV'] : '',
            'init_time_av' => isset($MODULE_VARS['CDNVideo']['CDN_Video_Cache_AV']) && !empty($MODULE_VARS['CDNVideo']['CDN_Video_Cache_AV']) ? (int)$MODULE_VARS['CDNVideo']['CDN_Video_Cache_AV'] : time(),
            'ttl_av' => isset($MODULE_VARS['CDNVideo']['CDN_Video_TTL_AV']) && !empty($MODULE_VARS['CDNVideo']['CDN_Video_TTL_AV']) ? (int)$MODULE_VARS['CDNVideo']['CDN_Video_TTL_AV'] : 14*24*3600,
        );
        
        return $config;
    }
    
    private static function _updateCDNVideoCacheTime($time,$timeAV){
        $config = self::getCDNVideoCofig();
        $config['init_time'] = $time;
        if($timeAV > 0){
            $config['init_time_av'] = $timeAV;
        }
        $mapping = array(
            'CDN_Video_Active' => ($config['active'] === true) ? 'true' : 'false',
            'CDN_Video_ID' => $config['id'],
            'CDN_Video_URL' => $config['domain'],
            'CDN_Video_Cache' => $config['init_time'],
            'CDN_Video_TTL' => $config['ttl'],
            'CDN_Video_Active_AV' => ($config['active_av'] === true) ? 'true' : 'false',
            'CDN_Video_URL_AV' => $config['domain_av'],
            'CDN_Video_Cache_AV' => $config['init_time_av'],
            'CDN_Video_TTL_AV' => $config['ttl_av'],
        );
        self::saveParameters($mapping);
    }
    
    public static function saveParameters($mapping){
        $Parameters = "";
        foreach($mapping as $key => $value){
            $Parameters .= $key . "=" . $value . "\n";
        }
        
        global $db;
        $ModuleID = $db->get_var("SELECT `Module_ID` FROM `Module` WHERE `Keyword` = 'CDNVideo'");
        $db->last_error = "";
        $db->query("UPDATE Module SET Parameters='".$db->escape($Parameters)."' WHERE Module_ID='".$ModuleID."'");
    }
    
    public static function processOutPut($input){

        $config = self::getCDNVideoCofig();
        if (!$config['active']) {
            return $input;
        }
        
        $config['domain'] = explode(',', $config['domain']);
        $config['domain_av'] = explode(',', $config['domain_av']);

        $CDNconfig = array();
        $CDNconfig[] = array(
            'id' => $config['id'],
            'domain' => $config['domain'],
            'targets' => array(
                'css', 'js', 'jpeg', 'jpg', 'png', 'gif',

            ),
            'init_time' => $config['init_time'], // default: time()
            'ttl'       => $config['ttl'], // default: 14 days
            'chainKey'  => 'files',
        );
        if($config['active_av']){
            $CDNconfig[] = array(
                'id' => $config['id'],
                'domain' => $config['domain_av'],
                'targets' => array(
                    'mp3', 'mp4', 'ogg', 'flv',
                ),
                'init_time' => $config['init_time_av'], // default: time()
                'ttl'       => $config['ttl_av'], // default: 14 days
                'chainKey'  => 'AV',
            );
        }
        $CDNChain = new \CDNVideo\CDNChain();
        foreach($CDNconfig as $conf){
            $CDNChain->addChainElement($conf);
        }
        $result = $CDNChain->process($input);
        self::_updateCDNVideoCacheTime($CDNChain->getCacheTime('files'),$CDNChain->getCacheTime('AV'));
        
        return $result;
    }
}
